/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.AbstractAction2;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ActionedUndoManager
extends UndoManager {
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    public static final byte[] UNDO_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 24, 0, 24, 0, -94, -1, 0, -1, -1, -1, -52, -52, -1, -103, -103, -52, 51, 51, 102, 0, 0, 0, -64, -64, -64, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 5, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 0, 3, 97, 88, -70, -36, -2, 48, -54, 66, -86, -99, -83, -122, -51, 43, -90, -101, 32, -114, 27, 49, 17, -63, -88, -110, 4, 32, 17, -93, 5, -85, -19, 43, -76, 64, 62, -117, -11, -21, 50, -69, -37, -17, -77, -40, -11, -120, 10, 20, 111, -120, 84, 10, 49, -125, 76, -22, -7, 26, 12, -99, 84, 8, -54, -102, -100, 102, 31, -54, -127, -59, -5, -107, -118, 56, -28, -93, 3, -69, 90, -98, -38, 60, 117, 100, 38, -74, -28, -102, 2, 46, 50, -93, -33, 51, -6, 126, 126, 9, 0, 33, -2, 79, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 50, 48, 48, 48, 32, 98, 121, 32, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 44, 32, 73, 110, 99, 46, 32, 65, 108, 108, 32, 82, 105, 103, 104, 116, 115, 32, 82, 101, 115, 101, 114, 118, 101, 100, 46, 13, 10, 74, 76, 70, 32, 71, 82, 32, 86, 101, 114, 32, 49, 46, 48, 13, 10, 0, 59};
    public static final Icon UNDO_ICON = new ImageIcon(TOOLKIT.createImage(UNDO_ICON_BYTES), "Undo");
    public static final byte[] REDO_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 24, 0, 24, 0, -94, -1, 0, -1, -1, -1, -52, -52, -1, -103, -103, -52, 51, 51, 102, 0, 0, 0, -64, -64, -64, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 5, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 0, 3, 101, 88, -70, -36, -2, -80, -116, 72, -39, 32, -75, -114, -128, 51, 35, 32, -79, 9, 93, 6, 6, 104, 42, -112, 38, -70, -66, 112, -7, 16, 1, 108, -109, 64, 68, -57, -32, -80, 18, 57, 93, -19, 7, 40, -6, -128, -108, 29, 113, 113, 9, 10, -105, 76, -25, 19, -25, 105, 40, -111, -43, -59, 85, 90, 85, -78, -84, -83, -105, -116, 38, -101, 13, 5, -100, -48, -80, -20, -16, -90, -50, 95, -35, 45, -58, -99, 17, 110, -96, 58, 4, 16, 10, 21, -77, 5, 69, -126, 122, -128, 20, 9, 0, 33, -2, 79, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 50, 48, 48, 48, 32, 98, 121, 32, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 44, 32, 73, 110, 99, 46, 32, 65, 108, 108, 32, 82, 105, 103, 104, 116, 115, 32, 82, 101, 115, 101, 114, 118, 101, 100, 46, 13, 10, 74, 76, 70, 32, 71, 82, 32, 86, 101, 114, 32, 49, 46, 48, 13, 10, 0, 59};
    public static final Icon REDO_ICON = new ImageIcon(TOOLKIT.createImage(REDO_ICON_BYTES), "Redo");
    private AbstractAction2 undoAction = new UndoAction();
    private AbstractAction2 redoAction = new RedoAction();
    private boolean needsUpdate = false;

    public ActionedUndoManager() {
        this.undoAction.setEnabled(this.canUndo());
        this.redoAction.setEnabled(this.canRedo());
    }

    public AbstractAction2 getUndoAction() {
        return this.undoAction;
    }

    public AbstractAction2 getRedoAction() {
        return this.redoAction;
    }

    @Override
    public void discardAllEdits() {
        this.needsUpdate = true;
        super.discardAllEdits();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    protected void trimForLimit() {
        this.needsUpdate = true;
        super.trimForLimit();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    protected void trimEdits(int from, int to) {
        this.needsUpdate = true;
        super.trimEdits(from, to);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public void setLimit(int l) {
        this.needsUpdate = true;
        super.setLimit(l);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        this.needsUpdate = true;
        super.undoTo(edit);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        this.needsUpdate = true;
        super.redoTo(edit);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public void undoOrRedo() throws CannotRedoException, CannotUndoException {
        this.needsUpdate = true;
        super.undoOrRedo();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.needsUpdate = true;
        super.undo();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.needsUpdate = true;
        super.redo();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        this.needsUpdate = true;
        boolean returnValue = super.addEdit(anEdit);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
        return returnValue;
    }

    @Override
    public void end() {
        this.needsUpdate = true;
        super.end();
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.needsUpdate = true;
        super.undoableEditHappened(e);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        this.needsUpdate = true;
        boolean returnValue = super.replaceEdit(anEdit);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.undoAction.setEnabled(this.canUndo());
            this.redoAction.setEnabled(this.canRedo());
        }
        return returnValue;
    }

    protected class RedoAction
    extends AbstractAction2 {
        protected RedoAction() {
            super("Redo", REDO_ICON);
            this.setAccelerator(KeyStroke.getKeyStroke(89, TOOLKIT.getMenuShortcutKeyMask()));
            this.setMnemonic(82);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionedUndoManager.this.redo();
        }
    }

    protected class UndoAction
    extends AbstractAction2 {
        protected UndoAction() {
            super("Undo", UNDO_ICON);
            this.setAccelerator(KeyStroke.getKeyStroke(90, TOOLKIT.getMenuShortcutKeyMask()));
            this.setMnemonic(85);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionedUndoManager.this.undo();
        }
    }
}

